IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'ADM_ERRO_EST_NF_INTEGRACOES')
begin
CREATE TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES](
	[CODIGO] [int] NOT NULL,
	[CD_CONTROLE] [int] IDENTITY(1,1) NOT NULL,
	[NR_NF] [int] NOT NULL,
	[DT_EMI_NF] [datetime] NOT NULL,
	[CD_FORN] [int] NOT NULL,
	[SERIE_NF] [varchar](10) NOT NULL,
	[TP_TRANSA] [int] NOT NULL,
	[CNPJ_FORN] [varchar](50) NOT NULL,
	[NR_AUTORIZADOR] [varchar](150) NOT NULL,
	[JSON_ENVIADO] [varbinary](max) NOT NULL,
	[STS_ERRO] [int] NOT NULL,
	[CD_USU_CORRECAO] [int] NOT NULL,
	[DT_CORRECAO] [datetime] NULL,
 CONSTRAINT [PK_ADM_ERRO_EST_NF_INTEGRACOES_1] PRIMARY KEY CLUSTERED 
(
	[CODIGO] ASC,
	[CD_CONTROLE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CODIGO]  DEFAULT ((0)) FOR [CODIGO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_NR_NF]  DEFAULT ((0)) FOR [NR_NF]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_SERIE_NF]  DEFAULT ('') FOR [SERIE_NF]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_TP_TRANSA]  DEFAULT ((0)) FOR [TP_TRANSA]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CNPJ_FORN]  DEFAULT ('') FOR [CNPJ_FORN]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CHAVE_NFE]  DEFAULT ('') FOR [NR_AUTORIZADOR]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_STS_ERRO]  DEFAULT ((0)) FOR [STS_ERRO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CD_USU_CORRECAO]  DEFAULT ((0)) FOR [CD_USU_CORRECAO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_NF_INTEGRACOES_ADM_ERRO] FOREIGN KEY([CODIGO])
REFERENCES [dbo].[ADM_ERRO] ([CODIGO])

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] CHECK CONSTRAINT [FK_ADM_ERRO_EST_NF_INTEGRACOES_ADM_ERRO]
end

